<Query Kind="Statements">
  <Namespace>System.Security.Cryptography</Namespace>
</Query>

// tworzy parę kluczy prywatnego i publicznego i zapisuje ją na dysku

using (var rsa = new RSACryptoServiceProvider())
{
	File.WriteAllText ("PublicKeyOnly.xml", rsa.ToXmlString (false));
	File.WriteAllText ("PublicPrivate.xml", rsa.ToXmlString (true));
}

// szyfrowanie - zwróć uwagę, że bezpośrednio możemy szyfrować tylko krótki wiadomości

byte[] data = Encoding.UTF8.GetBytes ("Wiadomość do zaszyfrowania");

string publicKeyOnly = File.ReadAllText ("PublicKeyOnly.xml");
string publicPrivate = File.ReadAllText ("PublicPrivate.xml");

byte[] encrypted, decrypted;

using (var rsaPublicOnly = new RSACryptoServiceProvider())
{
	rsaPublicOnly.FromXmlString (publicKeyOnly);
	encrypted = rsaPublicOnly.Encrypt (data, true);

	// następny wiersz spowodowałby wyjątek, ponieważ potrzebny jest klucz prywatny
	// do rozszyfrowania:
	// decrypted = rsaPublicOnly.Decrypt (encrypted, true);
}

// rozszyfrowanie

using (var rsaPublicPrivate = new RSACryptoServiceProvider())
{
	// udane rozszyfrowanie przy użyciu klucza prywatnego
	rsaPublicPrivate.FromXmlString (publicPrivate);
	decrypted = rsaPublicPrivate.Decrypt (encrypted, true);
	
	Encoding.UTF8.GetString (decrypted).Dump ("decrypted");
}